# AI Writer API 白名单插件 v2.0

这是一个 WordPress 插件，用于解决 SiteGround 等主机的安全机制阻止 AI Writer 工具箱上传图片的问题。

## 下载链接

| 来源 | 链接 |
|------|------|
| Main Branch 用户 | 在 [writer.kongdehua.com](https://writer.kongdehua.com) 下载 |
| V2 Pipeline 用户 | 在 [superwriter.zeabur.app](https://superwriter.zeabur.app) 下载 |
| GitHub 直链 | [ai-writer-api-whitelist.zip](https://github.com/alankongx/ai-writer-toolbox-zeabur/raw/main/wordpress-plugin/ai-writer-api-whitelist.zip) |

**注意**：两个分支可以共用同一个插件！

## 新功能 (v2.0)

- **Sideload 模式**：AI Writer 只发送图片 URL，WordPress 服务器自行下载图片并存入媒体库
- **完全绕过 WAF**：请求不再包含大量图片数据，避免触发安全规则
- **批量处理**：支持一次处理多张图片
- **自动检测**：AI Writer 会自动检测插件是否安装

## 安装方法

### 方法一：在线安装（推荐）
1. 下载插件 ZIP 文件
2. 登录 WordPress 后台
3. 进入 **插件** → **安装插件** → **上传插件**
4. 选择下载的 ZIP 文件并上传
5. 激活插件

### 方法二：通过 FTP 上传
1. 解压 ZIP 文件
2. 使用 FTP 客户端连接到您的服务器
3. 将 `ai-writer-api-whitelist` 文件夹上传到 `/wp-content/plugins/` 目录
4. 登录 WordPress 后台，进入 **插件** 页面
5. 找到 "AI Writer API Whitelist" 并激活

## 配置

激活插件后：
1. 进入 **设置** → **AI Writer API**
2. 可以添加自定义 IP 白名单
3. 可以启用请求日志记录

## API 端点

插件注册以下 REST API 端点：

| 端点 | 方法 | 说明 |
|------|------|------|
| `/?rest_route=/ai-writer/v1/ping` | GET | 检测插件是否安装 |
| `/?rest_route=/ai-writer/v1/sideload` | POST | 下载单张图片 |
| `/?rest_route=/ai-writer/v1/sideload-batch` | POST | 批量下载图片 |

### Sideload 请求示例

```json
POST /?rest_route=/ai-writer/v1/sideload
Authorization: Basic [base64(username:app_password)]
Content-Type: application/json

{
    "image_url": "https://example.com/image.jpg",
    "filename": "my-image.jpg",
    "alt_text": "图片描述",
    "title": "图片标题"
}
```

### 响应示例

```json
{
    "ok": true,
    "id": 12345,
    "url": "https://your-site.com/wp-content/uploads/2026/01/my-image.jpg",
    "source_url": "https://your-site.com/wp-content/uploads/2026/01/my-image.jpg",
    "filename": "my-image.jpg"
}
```

## 功能

- ✅ 自动将 AI Writer Zeabur 服务器 IP 加入白名单
- ✅ 绕过 SG Security 的 Bot Protection
- ✅ 绕过 Wordfence 的流量检测
- ✅ 支持 Sideload 模式（WordPress 自行下载图片）
- ✅ 支持批量处理
- ✅ 支持自定义 IP 白名单
- ✅ 可选的请求日志记录

## 默认白名单 IP

- `43.166.139.249` - AI Writer Zeabur 服务器

## 故障排除

### 如果安装插件后仍然无法正常使用：

1. **检查插件是否激活** - 确保在插件列表中看到 "AI Writer API Whitelist" 处于激活状态

2. **检查用户权限** - 确保您在 AI Writer 中使用的 WordPress 用户具有"上传文件"权限

3. **测试 Ping 端点** - 在浏览器中访问 `https://您的域名/?rest_route=/ai-writer/v1/ping`，应该返回：
   ```json
   {"ok":true,"plugin":"ai-writer-api-whitelist","version":"2.0.0",...}
   ```

4. **检查日志** - 在插件设置中启用日志，查看 `/wp-content/ai-writer-api.log` 文件

5. **检查服务器出站连接** - 确保您的 WordPress 服务器可以访问外部 URL（用于下载图片）

## 兼容性

- WordPress 5.0+
- PHP 7.2+
- 兼容 SG Security, Wordfence, iThemes Security 等安全插件

## 更新日志

### v2.0.0 (2026-01-27)
- 新增 Sideload 模式
- 新增批量处理端点
- 新增 Ping 检测端点
- 支持 `?rest_route=` 方式绕过 WAF
- 改进日志记录

### v1.0.0
- 初始版本
- IP 白名单功能
- 基本安全插件绕过

## 许可证

MIT License
